# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import math  
import time
import datetime 
         
class SinkInput():
    def __init__(self, index, name, volume, sink, role):

        self.index = index
        self.name = name
        self.client = None
        self.volume = volume
        self.sink = sink
        self.__role = role

        self.volume_meter_level = 0
        self.volume_meter_last_non_zero_timestamp = time.mktime(datetime.datetime.min.timetuple())

        self.volume_target = 100

        self.__previous_volume = 0

        self.volume_check = True
        self.__status = False


    def get_media_role(self):
        if not self.__role: return self.client.role
        return self.__role

    def set_media_role(self, role):
        self.__role = role

    role = property(get_media_role, set_media_role)

 
    def set_meter(self, meter_level):
        timestamp = math.floor(time.mktime(datetime.datetime.now().timetuple()))
        if(meter_level > 0):
            self.volume_meter_last_non_zero_timestamp = timestamp
        self.volume_meter_level = meter_level

    def is_active(self):
        timestamp = math.floor(time.mktime(datetime.datetime.now().timetuple()))
        compare = timestamp - self.volume_meter_last_non_zero_timestamp
        if compare <= 1:
            return True
        return False



    ## new per sink settings ##
    def set_volume(self):

        current_volume = round(self.volume[0])
        step_volume = current_volume
        result = True

        if current_volume < self.volume_target:      
            step_volume = current_volume + self.client.volume_step
            if not self.client.fade_volume: step_volume = self.volume_target
        elif current_volume > self.volume_target: 
            step_volume = current_volume - self.client.volume_step
            if not self.client.fade_volume: step_volume = self.volume_target
        
        if step_volume > 100:
            step_volume = 100
        if step_volume < self.client.volume_step:
            step_volume = self.client.volume_step

        # we dont want to get stuck in a loop because volumes arn't exactly the same 
        result = math.fabs(self.__previous_volume - current_volume) >= self.client.volume_step
        volume_check = math.fabs(self.client.volume_target - current_volume) < self.client.volume_step

        if result:
            for i in range(0, len(self.volume)):
                self.volume[i] = step_volume

            #print "\nAdjust Volume", self.client.name, step_volume
        
        if volume_check and not self.volume_check:
            self.volume_check = volume_check
            self.client.check_volume()

        self.volume_check = volume_check

        self.__previous_volume = step_volume       
        return result

    def get_volume_meter(self):
        return sink.volume_meter_level

    def __fade_in(self):
        self.volume_target = self.client.volume_max

    def __fade_out(self):
        if self.client.volume_min == -1:
            self.volume_target = self.client.core.mute_level
        else:
            self.volume_target = self.client.volume_min

    def __fade_mute(self):
        if self.client.volume_min == -1:
            self.volume_target = self.client.core.mute_level
        else:
            self.volume_target = self.client.volume_min

        # if we goto 0 than our volume meter will never register a value
        if self.volume_target < self.client.volume_step:
            self.volume_target = self.client.volume_step
    
    def set_status(self, value):
        
        if value or self.role == "default":
            self.__fade_in()
        else:
            self.__fade_mute()

        self.__status = value

    def get_status(self):
        return self.__status







