/* Pango
 * pangographite.h: SILGraphite support for pango module
 *
 * Copyright (C) 2004, 2005 SIL International
 * Author: Daniel Glassey <wdg@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

void graphite_PangoGlyphString(const char *text, 
        int         length, 
        PangoFcFont     *font, 
        PangoGlyphString *glyphs,
        const char *language,
        int rtl);

void graphite_PangoLogAttrs(const char *text,
      int length,
      PangoFcFont *font, 
      PangoLogAttr *attrs,
      int attrs_len,
      const char *language,
      int rtl);

#ifdef __cplusplus
}
#endif

