/*	Processing_Listener

PIRL CVS ID: Processing_Listener.java,v 1.5 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor;

import	java.util.EventListener;

/**	A <i>Processing_Listener</i> specifies the interface to receive
	Conductor Processing_Event notifications.
<p>
	Implementors of the Processing_Listener interface can {@link
	Management#Add_Processing_Listener(Processing_Listener) register}
	with the Conductor Management interface to receive Conductor
	Processing_Event notifications
<p>
	@author		Bradford Castalia - UA/PIRL
	@version	1.5
	@see	Management
*/
public interface Processing_Listener
	extends EventListener
{
/**	A Conductor Processing_Event occured.
<p>
	Whenever a significant processing event occurs by a Conductor it
	sends a Processing_Event to all {@link
	Management#Add_Processing_Listener(Processing_Listener) registered}
	listeners.
<p>
	@param	event	A Conductor Processing_Event.
	@see	Processing_Event
*/
public void Processing_Event_Occurred
	(
	Processing_Event	event
	);
}
