# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+
package Uploader::GUI::wxImageReuploadDlg;
use strict;
use Wx qw/
             wxDefaultSize
             wxDefaultPosition
             wxID_CANCEL
             wxID_OK
             wxSTAY_ON_TOP
         /;
#use base qw/Wx::Dialog Class::Accessor::Fast Uploader::GUI::DlgCommon/;
use base qw/Wx::Dialog Uploader::GUI::DlgCommon/;
use Wx::Event qw/
                    EVT_BUTTON
                    EVT_CLOSE
                /;

use Carp;

sub new {
    my ($this, $params) = @_;
    #on recupere le nom de la classe en fonction du type d'appel de la mthode.
    my $class = ref($this) || $this;


    my $self = $class->SUPER::new( undef, -1, $params->{title}, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP);
    # load controls
    eval {
      &main::Reupload($self, 1);

        $self->properties(
            $params->{properties}
        );
        $self->InitLabels();
        $self->SetProperties();
        $self->_initEventHandlers();

        if($@){
            Wx::LogMessage("Error during dialogbox initialization");
        }
    };

    $self;    
}



sub _initEventHandlers {
    my ( $self ) = @_;
    
    EVT_BUTTON( $self, $main::ID_REUPLOAD_OK, \&OnOK );
    EVT_CLOSE( $self, \&OnClose );
}


sub OnOK {
    my ( $self, $event ) = @_;
    
    $self->_close;
}

sub OnClose {
    my ( $self, $event ) = @_;
    
    $self->_close;
}

sub _close {
    my ( $self ) = @_;

    $self->GetProperties();
        
    $self->Destroy;
}

1;