from typing import Any, ClassVar, Dict, Optional, Tuple

from typing_extensions import Literal

from ..core import BaseRenderer as BaseRenderer
from ..core import BlockState as BlockState
from ..util import safe_entity as safe_entity
from ..util import striptags as striptags

class HTMLRenderer(BaseRenderer):
    NAME: ClassVar[Literal["html"]]
    HARMFUL_PROTOCOLS: ClassVar[Tuple[str, ...]]
    GOOD_DATA_PROTOCOLS: ClassVar[Tuple[str, ...]]
    _escape: bool
    def __init__(
        self, escape: bool = True, allow_harmful_protocols: Optional[bool] = None
    ) -> None: ...
    def render_token(self, token: Dict[str, Any], state: BlockState) -> str: ...
    def safe_url(self, url: str) -> str: ...
    def text(self, text: str) -> str: ...
    def emphasis(self, text: str) -> str: ...
    def strong(self, text: str) -> str: ...
    def link(self, text: str, url: str, title: Optional[str] = None) -> str: ...
    def image(self, text: str, url: str, title: Optional[str] = None) -> str: ...
    def codespan(self, text: str) -> str: ...
    def linebreak(self) -> str: ...
    def softbreak(self) -> str: ...
    def inline_html(self, html: str) -> str: ...
    def paragraph(self, text: str) -> str: ...
    def heading(self, text: str, level: int, **attrs: Any) -> str: ...
    def blank_line(self) -> str: ...
    def thematic_break(self) -> str: ...
    def block_text(self, text: str) -> str: ...
    def block_code(self, code: str, info: Optional[str] = None) -> str: ...
    def block_quote(self, text: str) -> str: ...
    def block_html(self, html: str) -> str: ...
    def block_error(self, text: str) -> str: ...
    def list(self, text: str, ordered: bool, **attrs: Any) -> str: ...
    def list_item(self, text: str) -> str: ...
