% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPOSIXct.R
\name{checkPOSIXct}
\alias{checkPOSIXct}
\alias{check_posixct}
\alias{assertPOSIXct}
\alias{assert_posixct}
\alias{testPOSIXct}
\alias{test_posixct}
\alias{expect_posixct}
\title{Check that an argument is a date/time object in POSIXct format}
\usage{
checkPOSIXct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE
)

check_posixct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE
)

assertPOSIXct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_posixct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testPOSIXct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE
)

test_posixct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE
)

expect_posixct(
  x,
  lower = NULL,
  upper = NULL,
  any.missing = TRUE,
  all.missing = TRUE,
  len = NULL,
  min.len = NULL,
  max.len = NULL,
  unique = FALSE,
  sorted = FALSE,
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{lower}{[\code{\link[base]{Date}}]\cr
All non-missing dates in \code{x} must be >= this POSIXct time. Must be provided in the same timezone as \code{x}.}

\item{upper}{[\code{\link[base]{Date}}]\cr
All non-missing dates in \code{x} must be <= this POSIXct time. Must be provided in the same timezone as \code{x}.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{sorted}{[\code{logical(1)}]\cr
Elements must be sorted in ascending order. Missing values are ignored.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertAtomic}/\code{assert_atomic} return 
 \code{x} invisibly, whereas
 \code{checkAtomic}/\code{check_atomic} and 
 \code{testAtomic}/\code{test_atomic} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertAtomic}/\code{assert_atomic}
 throws an error message, 
 \code{testAtomic}/\code{test_atomic}
 returns \code{FALSE},
 and \code{checkAtomic} returns a string with the error message.
 The function \code{expect_atomic} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Checks that an object is of class \code{\link[base]{POSIXct}}.
}
\seealso{
Other basetypes: 
\code{\link{checkArray}()},
\code{\link{checkAtomicVector}()},
\code{\link{checkAtomic}()},
\code{\link{checkCharacter}()},
\code{\link{checkComplex}()},
\code{\link{checkDataFrame}()},
\code{\link{checkDate}()},
\code{\link{checkDouble}()},
\code{\link{checkEnvironment}()},
\code{\link{checkFactor}()},
\code{\link{checkFormula}()},
\code{\link{checkFunction}()},
\code{\link{checkIntegerish}()},
\code{\link{checkInteger}()},
\code{\link{checkList}()},
\code{\link{checkLogical}()},
\code{\link{checkMatrix}()},
\code{\link{checkNull}()},
\code{\link{checkNumeric}()},
\code{\link{checkRaw}()},
\code{\link{checkVector}()}
}
\concept{basetypes}
