% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{graph.bfs}
\alias{graph.bfs}
\title{Breadth-first search}
\usage{
graph.bfs(
  graph,
  root,
  mode = c("out", "in", "all", "total"),
  unreachable = TRUE,
  restricted = NULL,
  order = TRUE,
  rank = FALSE,
  father = FALSE,
  pred = FALSE,
  succ = FALSE,
  dist = FALSE,
  callback = NULL,
  extra = NULL,
  rho = parent.frame(),
  neimode
)
}
\arguments{
\item{graph}{The input graph.}

\item{root}{Numeric vector, usually of length one. The root vertex, or root
vertices to start the search from.}

\item{mode}{For directed graphs specifies the type of edges to follow.
\sQuote{out} follows outgoing, \sQuote{in} incoming edges. \sQuote{all}
ignores edge directions completely. \sQuote{total} is a synonym for
\sQuote{all}. This argument is ignored for undirected graphs.}

\item{unreachable}{Logical scalar, whether the search should visit the
vertices that are unreachable from the given root vertex (or vertices). If
\code{TRUE}, then additional searches are performed until all vertices are
visited.}

\item{restricted}{\code{NULL} (=no restriction), or a vector of vertices
(ids or symbolic names). In the latter case, the search is restricted to the
given vertices.}

\item{order}{Logical scalar, whether to return the ordering of the vertices.}

\item{rank}{Logical scalar, whether to return the rank of the vertices.}

\item{father}{Logical scalar, whether to return the father of the vertices.}

\item{pred}{Logical scalar, whether to return the predecessors of the
vertices.}

\item{succ}{Logical scalar, whether to return the successors of the
vertices.}

\item{dist}{Logical scalar, whether to return the distance from the root of
the search tree.}

\item{callback}{If not \code{NULL}, then it must be callback function. This
is called whenever a vertex is visited. See details below.}

\item{extra}{Additional argument to supply to the callback function.}

\item{rho}{The environment in which the callback function is evaluated.}

\item{neimode}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This argument is deprecated
from igraph 1.3.0; use \code{mode} instead.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{graph.bfs()} was renamed to \code{bfs()} to create a more
consistent API.
}
\keyword{internal}
