% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{MAE}
\alias{MAE}
\title{Mean Absolute Error Loss}
\usage{
MAE(y_pred, y_true)
}
\arguments{
\item{y_pred}{Estimated target values vector}

\item{y_true}{Ground truth (correct) target values vector}
}
\value{
Mean Absolute Error Loss
}
\description{
Compute the mean absolute error regression loss.
}
\examples{
data(cars)
reg <- lm(log(dist) ~ log(speed), data = cars)
MAE(y_pred = exp(reg$fitted.values), y_true = cars$dist)
}

