% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressor.R
\name{progressor}
\alias{progressor}
\title{Create a Progressor Function that Signals Progress Updates}
\usage{
progressor(
  steps = length(along),
  along = NULL,
  offset = 0L,
  scale = 1L,
  transform = function(steps) scale * steps + offset,
  message = character(0L),
  label = NA_character_,
  trace = FALSE,
  initiate = TRUE,
  auto_finish = TRUE,
  on_exit = !identical(envir, globalenv()),
  enable = getOption("progressr.enable", TRUE),
  envir = parent.frame()
)
}
\arguments{
\item{steps}{(integer) Number of progressing steps.}

\item{along}{(vector; alternative) Alternative that sets
\code{steps = length(along)}.}

\item{offset, scale}{(integer; optional) scale and offset applying transform
\code{steps <- scale * steps + offset}.}

\item{transform}{(function; optional) A function that takes the effective
number of \code{steps} as input and returns another finite and non-negative
number of steps.}

\item{message}{(character vector or a function) If a character vector, then
it is pasted together into a single string using an empty separator.
If a function, then the message is constructed by \code{conditionMessage(p)}
calling this function with the progression condition \code{p} itself as the
first argument.}

\item{label}{(character) A label.}

\item{trace}{(logical) If TRUE, then the call stack is recorded, otherwise
not.}

\item{initiate}{(logical) If TRUE, the progressor will signal a
\link{progression} 'initiate' condition when created.}

\item{auto_finish}{(logical) If TRUE, then the progressor will signal a
\link{progression} 'finish' condition as soon as the last step has been reached.}

\item{on_exit, envir}{(logical) If TRUE, then the created progressor will
signal a \link{progression} 'finish' condition when the calling frame exits.
This is ignored if the calling frame (\code{envir}) is the global environment.}

\item{enable}{(logical) If TRUE, \link{progression} conditions are signaled when
calling the progressor function created by this function.
If FALSE, no \link{progression} conditions is signaled because the progressor
function is an empty function that does nothing.}
}
\value{
A function of class \code{progressor}.
}
\description{
Create a Progressor Function that Signals Progress Updates
}
\details{
A \code{progressor} function can only be created inside a local environment,
e.g. inside a function, within a \code{local()} call, or within a
\code{with_progress()} call.  Notably, it \emph{cannot} be create at the top level,
e.g. immediately at the R prompt or outside a local environment in an
R script.  If attempted, an informative error message is produced, e.g.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{> p <- progressr::progressor(100)
Error in progressr::progressor(100) : 
  A progressor must not be created in the global environment unless
wrapped in a with_progress() or without_progress() call. Alternatively,
create it inside a function or in a local() environment to make sure
there is a finite life span of the progressor
}\if{html}{\out{</div>}}
}
