% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.bSpline2}
\alias{predict.dbs}
\alias{predict.ibs}
\alias{predict.mSpline}
\alias{predict.iSpline}
\alias{predict.cSpline}
\alias{predict.bernsteinPoly}
\alias{predict.naturalSpline}
\title{Evaluate Spline Basis Functions at Specified Points}
\usage{
\method{predict}{bSpline2}(object, newx, ...)

\method{predict}{dbs}(object, newx, ...)

\method{predict}{ibs}(object, newx, ...)

\method{predict}{mSpline}(object, newx, ...)

\method{predict}{iSpline}(object, newx, ...)

\method{predict}{cSpline}(object, newx, ...)

\method{predict}{bernsteinPoly}(object, newx, ...)

\method{predict}{naturalSpline}(object, newx, ...)
}
\arguments{
\item{object}{Objects of class \code{bSpline2}, \code{ibs}, \code{mSpline},
\code{iSpline}, \code{cSpline}, \code{bernsteinPoly} or
\code{naturalSpline} with attributes describing \code{knots},
\code{degree}, etc.}

\item{newx}{The \code{x} values at which evaluations are required.}

\item{...}{Optional arguments that are not used.}
}
\value{
An object just like the \code{object} input, except evaluated at
the new values of \code{x}.
}
\description{
This function evaluates the given spline basis functions at the specified
\code{x}.
}
\details{
These are methods for the generic function \code{predict} for objects
inheriting from class \code{bSpline2}, \code{ibs}, \code{mSpline},
\code{iSpline}, \code{cSpline}, \code{naturalSpline}, or
\code{bernsteinPoly}.  If \code{newx} is not given, the function returns the
input object.
}
\examples{
library(splines2)
x <- seq.int(0, 1, 0.2)
knots <- c(0.3, 0.5, 0.6)
newX <- seq.int(0.1, 0.9, 0.2)

## for B-splines
bsMat <- bSpline(x, knots = knots, degree = 2)
predict(bsMat, newX)

## for integral of B-splines
ibsMat <- ibs(x, knots = knots, degree = 2)
predict(ibsMat, newX)

## for derivative of B-splines
dbsMat <- dbs(x, knots = knots, degree = 2)
predict(dbsMat, newX)

## for M-spline
msMat <- mSpline(x, knots = knots, degree = 2)
predict(msMat, newX)

## for I-spline
isMat <- iSpline(x, knots = knots, degree = 2)
predict(isMat, newX)

## for C-spline
csMat <- cSpline(x, knots = knots, degree = 2)
predict(csMat, newX)
}
