// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Unit.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class Unit_2_0_0 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.Unit:2.0.0", null);

    public Unit_2_0_0(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Unit_2_0_0(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Unit_2_0_0 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Unit_2_0_0(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAM = 1;

    public enum Orientation {
      NORMAL,
      FLIPPED,
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.hasOrientationSensor = this.hasOrientationSensor;
        copy.supportedDisplayOrientations = this.supportedDisplayOrientations;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["hasOrientationSensor"] = this.hasOrientationSensor;
        json["supportedDisplayOrientations"] = new JsonArray(this.supportedDisplayOrientations.Select(
          _value => (JsonValue)((int)_value)));
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.hasOrientationSensor = (bool)json["hasOrientationSensor"];
        inst.supportedDisplayOrientations = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation>(json["supportedDisplayOrientations"].AsJsonArray.Select(
          _value => (Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation)(int)_value));
        return inst;
      }

      public bool hasOrientationSensor = false;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation> supportedDisplayOrientations = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation>();
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.buzzerMuted = this.buzzerMuted;
        copy.autoDisplayOrientation = this.autoDisplayOrientation;
        copy.displayOrientation = this.displayOrientation;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["buzzerMuted"] = this.buzzerMuted;
        json["autoDisplayOrientation"] = this.autoDisplayOrientation;
        json["displayOrientation"] = (int)this.displayOrientation;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.buzzerMuted = (bool)json["buzzerMuted"];
        inst.autoDisplayOrientation = (bool)json["autoDisplayOrientation"];
        inst.displayOrientation = (Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation)(int)json["displayOrientation"];
        return inst;
      }

      public bool buzzerMuted = false;
      public bool autoDisplayOrientation = false;
      public Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation displayOrientation = Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation.NORMAL;
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.pdumodel.Unit_2_0_0.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_2_0_0.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_2_0_0.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.pdumodel.Unit_2_0_0.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_2_0_0.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Unit_2_0_0.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.pdumodel.Unit_2_0_0.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Unit_2_0_0.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.Unit_2_0_0.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class IdentifyResult {
    }

    public IdentifyResult identify(int seconds) {
      var _parameters = new LightJson.JsonObject();
      _parameters["seconds"] = seconds;

      var _result = RpcCall("identify", _parameters);
      var _ret = new IdentifyResult();
      return _ret;
    }

    public AsyncRequest identify(int seconds, AsyncRpcResponse<IdentifyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return identify(seconds, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest identify(int seconds, AsyncRpcResponse<IdentifyResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["seconds"] = seconds;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("identify", _parameters,
        _result => {
          try {
            var _ret = new IdentifyResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class MuteBuzzerResult {
    }

    public MuteBuzzerResult muteBuzzer(bool mute) {
      var _parameters = new LightJson.JsonObject();
      _parameters["mute"] = mute;

      var _result = RpcCall("muteBuzzer", _parameters);
      var _ret = new MuteBuzzerResult();
      return _ret;
    }

    public AsyncRequest muteBuzzer(bool mute, AsyncRpcResponse<MuteBuzzerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return muteBuzzer(mute, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest muteBuzzer(bool mute, AsyncRpcResponse<MuteBuzzerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["mute"] = mute;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("muteBuzzer", _parameters,
        _result => {
          try {
            var _ret = new MuteBuzzerResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDisplayOrientationResult {
      public Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation _ret_;
    }

    public GetDisplayOrientationResult getDisplayOrientation() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDisplayOrientation", _parameters);
      var _ret = new GetDisplayOrientationResult();
      _ret._ret_ = (Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation)(int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getDisplayOrientation(AsyncRpcResponse<GetDisplayOrientationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDisplayOrientation(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDisplayOrientation(AsyncRpcResponse<GetDisplayOrientationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDisplayOrientation", _parameters,
        _result => {
          try {
            var _ret = new GetDisplayOrientationResult();
            _ret._ret_ = (Com.Raritan.Idl.pdumodel.Unit_2_0_0.Orientation)(int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
