#! /bin/sh

# Test update of a record.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g').db

DB_DIR=db
DB_FILE=${DB_DIR}/test3.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}

cp ${DB_FILE} ${TMP_DB_FILE}

unset $(printenv | awk -F= '!/^PATH=/&&!/PERL5LIB/&&/=/{print $1}' | grep -v '()')

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/bibliography/7"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=POST
export QUERY_STRING=""
export CONTENT_TYPE="multipart/form-data; boundary=---------------------------177715475815357427681614857572"
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

echo "==="

${INPUT_SCRIPT} <<EOF |
-----------------------------177715475815357427681614857572
Content-Disposition: form-data; name="column:bibliography:0.id"

7
-----------------------------177715475815357427681614857572
Content-Disposition: form-data; name="column:bibliography:0.authors"

Saulius Gražulis
-----------------------------177715475815357427681614857572
Content-Disposition: form-data; name="column:bibliography:0.title"

UTF-8 test žžž
-----------------------------177715475815357427681614857572
Content-Disposition: form-data; name="column:bibliography:0.year"

2018
-----------------------------177715475815357427681614857572
Content-Disposition: form-data; name="Update"

Update
-----------------------------177715475815357427681614857572--
EOF
sed "s/${TMP_TEST_DB}/database/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
