# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CDN
  #
  # Use these APIs to manage Azure CDN resources through the Azure Resource
  # Manager. You must make sure that requests made to these resources are
  # secure.
  #
  class CustomDomains
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CustomDomains class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [CdnManagementClient] reference to the CdnManagementClient
    attr_reader :client

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CustomDomain>] operation results.
    #
    def list_by_endpoint(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      first_page = list_by_endpoint_as_lazy(resource_group_name, profile_name, endpoint_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_endpoint_with_http_info(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      list_by_endpoint_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
    end

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_endpoint_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomainListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets an exisitng custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def get(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      response = get_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an exisitng custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      get_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
    end

    #
    # Gets an exisitng custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_name is nil' if custom_domain_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'customDomainName' => custom_domain_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_domain_properties [CustomDomainParameters] Properties required
    # to create a new custom domain.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def create(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers = nil)
      response = create_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_domain_properties [CustomDomainParameters] Properties required
    # to create a new custom domain.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers = nil)
      # Send request
      promise = begin_create_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes an existing custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def delete(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      response = delete_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Disable https delivery of the custom domain.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def disable_custom_https(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      response = disable_custom_https_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Disable https delivery of the custom domain.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def disable_custom_https_with_http_info(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      disable_custom_https_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
    end

    #
    # Disable https delivery of the custom domain.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def disable_custom_https_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_name is nil' if custom_domain_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/disableCustomHttps'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'customDomainName' => custom_domain_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Enable https delivery of the custom domain.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def enable_custom_https(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      response = enable_custom_https_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Enable https delivery of the custom domain.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def enable_custom_https_with_http_info(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      enable_custom_https_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
    end

    #
    # Enable https delivery of the custom domain.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def enable_custom_https_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_name is nil' if custom_domain_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}/enableCustomHttps'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'customDomainName' => custom_domain_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_domain_properties [CustomDomainParameters] Properties required
    # to create a new custom domain.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def begin_create(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers = nil)
      response = begin_create_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_domain_properties [CustomDomainParameters] Properties required
    # to create a new custom domain.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers = nil)
      begin_create_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers).value!
    end

    #
    # Creates a new custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_domain_properties [CustomDomainParameters] Properties required
    # to create a new custom domain.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_domain_properties, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_name is nil' if custom_domain_name.nil?
      fail ArgumentError, 'custom_domain_properties is nil' if custom_domain_properties.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CDN::Models::CustomDomainParameters.mapper()
      request_content = @client.serialize(request_mapper,  custom_domain_properties)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'customDomainName' => custom_domain_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an existing custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomain] operation results.
    #
    def begin_delete(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes an existing custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers).value!
    end

    #
    # Deletes an existing custom domain within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_name [String] Name of the custom domain within an
    # endpoint.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_domain_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_name is nil' if custom_domain_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/customDomains/{customDomainName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'customDomainName' => custom_domain_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomain.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomainListResult] operation results.
    #
    def list_by_endpoint_next(next_page_link, custom_headers = nil)
      response = list_by_endpoint_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_endpoint_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_endpoint_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_endpoint_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::CustomDomainListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the existing custom domains within an endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomDomainListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_endpoint_as_lazy(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = list_by_endpoint_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_endpoint_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
