# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CDN
  #
  # Use these APIs to manage Azure CDN resources through the Azure Resource
  # Manager. You must make sure that requests made to these resources are
  # secure.
  #
  class Endpoints
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Endpoints class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [CdnManagementClient] reference to the CdnManagementClient
    attr_reader :client

    #
    # Lists existing CDN endpoints.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Endpoint>] operation results.
    #
    def list_by_profile(resource_group_name, profile_name, custom_headers = nil)
      first_page = list_by_profile_as_lazy(resource_group_name, profile_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists existing CDN endpoints.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_profile_with_http_info(resource_group_name, profile_name, custom_headers = nil)
      list_by_profile_async(resource_group_name, profile_name, custom_headers).value!
    end

    #
    # Lists existing CDN endpoints.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_profile_async(resource_group_name, profile_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::EndpointListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def get(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = get_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      get_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
    end

    #
    # Gets an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint [Endpoint] Endpoint properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def create(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers = nil)
      response = create_async(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint [Endpoint] Endpoint properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers = nil)
      # Send request
      promise = begin_create_async(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile. Only tags and Origin
    # HostHeader can be updated after creating an endpoint. To update origins, use
    # the Update Origin operation. To update custom domains, use the Update Custom
    # Domain operation.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint_update_properties [EndpointUpdateParameters] Endpoint update
    # properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def update(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers = nil)
      response = update_async(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint_update_properties [EndpointUpdateParameters] Endpoint update
    # properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers = nil)
      # Send request
      promise = begin_update_async(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = delete_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Starts an existing CDN endpoint that is on a stopped state.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def start(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = start_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      # Send request
      promise = begin_start_async(resource_group_name, profile_name, endpoint_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def stop(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = stop_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def stop_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      # Send request
      promise = begin_stop_async(resource_group_name, profile_name, endpoint_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Removes a content from CDN.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can be a full URL, e.g. '/pictures/city.png' which removes a
    # single file, or a directory with a wildcard, e.g. '/pictures/*' which removes
    # all folders and files in the directory.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def purge_content(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      response = purge_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can be a full URL, e.g. '/pictures/city.png' which removes a
    # single file, or a directory with a wildcard, e.g. '/pictures/*' which removes
    # all folders and files in the directory.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def purge_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      # Send request
      promise = begin_purge_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Pre-loads a content to CDN. Available for Verizon Profiles.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should be a full URL, e.g. ‘/pictires/city.png' which loads a
    # single file
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def load_content(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      response = load_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should be a full URL, e.g. ‘/pictires/city.png' which loads a
    # single file
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def load_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      # Send request
      promise = begin_load_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Validates the custom domain mapping to ensure it maps to the correct CDN
    # endpoint in DNS.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_properties [ValidateCustomDomainInput] Custom domain to
    # be validated.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ValidateCustomDomainOutput] operation results.
    #
    def validate_custom_domain(resource_group_name, profile_name, endpoint_name, custom_domain_properties, custom_headers = nil)
      response = validate_custom_domain_async(resource_group_name, profile_name, endpoint_name, custom_domain_properties, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Validates the custom domain mapping to ensure it maps to the correct CDN
    # endpoint in DNS.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_properties [ValidateCustomDomainInput] Custom domain to
    # be validated.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def validate_custom_domain_with_http_info(resource_group_name, profile_name, endpoint_name, custom_domain_properties, custom_headers = nil)
      validate_custom_domain_async(resource_group_name, profile_name, endpoint_name, custom_domain_properties, custom_headers).value!
    end

    #
    # Validates the custom domain mapping to ensure it maps to the correct CDN
    # endpoint in DNS.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_domain_properties [ValidateCustomDomainInput] Custom domain to
    # be validated.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def validate_custom_domain_async(resource_group_name, profile_name, endpoint_name, custom_domain_properties, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'custom_domain_properties is nil' if custom_domain_properties.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CDN::Models::ValidateCustomDomainInput.mapper()
      request_content = @client.serialize(request_mapper,  custom_domain_properties)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/validateCustomDomain'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::ValidateCustomDomainOutput.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceUsage>] operation results.
    #
    def list_resource_usage(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      first_page = list_resource_usage_as_lazy(resource_group_name, profile_name, endpoint_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_resource_usage_with_http_info(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      list_resource_usage_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_resource_usage_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/checkResourceUsage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::ResourceUsageListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint [Endpoint] Endpoint properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_create(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers = nil)
      response = begin_create_async(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint [Endpoint] Endpoint properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers = nil)
      begin_create_async(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers).value!
    end

    #
    # Creates a new CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint [Endpoint] Endpoint properties
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(resource_group_name, profile_name, endpoint_name, endpoint, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'endpoint is nil' if endpoint.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
      request_content = @client.serialize(request_mapper,  endpoint)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile. Only tags and Origin
    # HostHeader can be updated after creating an endpoint. To update origins, use
    # the Update Origin operation. To update custom domains, use the Update Custom
    # Domain operation.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint_update_properties [EndpointUpdateParameters] Endpoint update
    # properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_update(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers = nil)
      response = begin_update_async(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile. Only tags and Origin
    # HostHeader can be updated after creating an endpoint. To update origins, use
    # the Update Origin operation. To update custom domains, use the Update Custom
    # Domain operation.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint_update_properties [EndpointUpdateParameters] Endpoint update
    # properties
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers = nil)
      begin_update_async(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers).value!
    end

    #
    # Updates an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile. Only tags and Origin
    # HostHeader can be updated after creating an endpoint. To update origins, use
    # the Update Origin operation. To update custom domains, use the Update Custom
    # Domain operation.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param endpoint_update_properties [EndpointUpdateParameters] Endpoint update
    # properties
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, profile_name, endpoint_name, endpoint_update_properties, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'endpoint_update_properties is nil' if endpoint_update_properties.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CDN::Models::EndpointUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  endpoint_update_properties)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      nil
    end

    #
    # Deletes an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
    end

    #
    # Deletes an existing CDN endpoint with the specified endpoint name under the
    # specified subscription, resource group and profile.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts an existing CDN endpoint that is on a stopped state.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_start(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = begin_start_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts an existing CDN endpoint that is on a stopped state.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      begin_start_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
    end

    #
    # Starts an existing CDN endpoint that is on a stopped state.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Endpoint] operation results.
    #
    def begin_stop(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = begin_stop_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_stop_with_http_info(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      begin_stop_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
    end

    #
    # Stops an existing running CDN endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_stop_async(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::Endpoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes a content from CDN.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can be a full URL, e.g. '/pictures/city.png' which removes a
    # single file, or a directory with a wildcard, e.g. '/pictures/*' which removes
    # all folders and files in the directory.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_purge_content(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      response = begin_purge_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers).value!
      nil
    end

    #
    # Removes a content from CDN.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can be a full URL, e.g. '/pictures/city.png' which removes a
    # single file, or a directory with a wildcard, e.g. '/pictures/*' which removes
    # all folders and files in the directory.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_purge_content_with_http_info(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      begin_purge_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers).value!
    end

    #
    # Removes a content from CDN.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [PurgeParameters] The path to the content to be
    # purged. Path can be a full URL, e.g. '/pictures/city.png' which removes a
    # single file, or a directory with a wildcard, e.g. '/pictures/*' which removes
    # all folders and files in the directory.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_purge_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'content_file_paths is nil' if content_file_paths.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CDN::Models::PurgeParameters.mapper()
      request_content = @client.serialize(request_mapper,  content_file_paths)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Pre-loads a content to CDN. Available for Verizon Profiles.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should be a full URL, e.g. ‘/pictires/city.png' which loads a
    # single file
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_load_content(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      response = begin_load_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers).value!
      nil
    end

    #
    # Pre-loads a content to CDN. Available for Verizon Profiles.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should be a full URL, e.g. ‘/pictires/city.png' which loads a
    # single file
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_load_content_with_http_info(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      begin_load_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers).value!
    end

    #
    # Pre-loads a content to CDN. Available for Verizon Profiles.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param content_file_paths [LoadParameters] The path to the content to be
    # loaded. Path should be a full URL, e.g. ‘/pictires/city.png' which loads a
    # single file
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_load_content_async(resource_group_name, profile_name, endpoint_name, content_file_paths, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'profile_name is nil' if profile_name.nil?
      fail ArgumentError, 'endpoint_name is nil' if endpoint_name.nil?
      fail ArgumentError, 'content_file_paths is nil' if content_file_paths.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::CDN::Models::LoadParameters.mapper()
      request_content = @client.serialize(request_mapper,  content_file_paths)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'profileName' => profile_name,'endpointName' => endpoint_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists existing CDN endpoints.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EndpointListResult] operation results.
    #
    def list_by_profile_next(next_page_link, custom_headers = nil)
      response = list_by_profile_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists existing CDN endpoints.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_profile_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_profile_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists existing CDN endpoints.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_profile_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::EndpointListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceUsageListResult] operation results.
    #
    def list_resource_usage_next(next_page_link, custom_headers = nil)
      response = list_resource_usage_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_resource_usage_next_with_http_info(next_page_link, custom_headers = nil)
      list_resource_usage_next_async(next_page_link, custom_headers).value!
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_resource_usage_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::CDN::Models::ResourceUsageListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists existing CDN endpoints.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [EndpointListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_profile_as_lazy(resource_group_name, profile_name, custom_headers = nil)
      response = list_by_profile_async(resource_group_name, profile_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_profile_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Checks the quota and usage of geo filters and custom domains under the given
    # endpoint.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param profile_name [String] Name of the CDN profile which is unique within
    # the resource group.
    # @param endpoint_name [String] Name of the endpoint under the profile which is
    # unique globally.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceUsageListResult] which provide lazy access to pages of the
    # response.
    #
    def list_resource_usage_as_lazy(resource_group_name, profile_name, endpoint_name, custom_headers = nil)
      response = list_resource_usage_async(resource_group_name, profile_name, endpoint_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_resource_usage_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
