# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::CognitiveServices
  module Models
    #
    # The list of cognitive services accounts operation response.
    #
    class CognitiveServicesAccountListResult

      include MsRestAzure

      include MsRest::JSONable
      # @return [String] The link used to get the next page of accounts.
      attr_accessor :next_link

      # @return [Array<CognitiveServicesAccount>] Gets the list of Cognitive
      # Services accounts and their properties.
      attr_accessor :value

      # return [Proc] with next page method call.
      attr_accessor :next_method

      #
      # Gets the rest of the items for the request, enabling auto-pagination.
      #
      # @return [Array<CognitiveServicesAccount>] operation results.
      #
      def get_all_items
        items = @value
        page = self
        while page.next_link != nil do
          page = page.get_next_page
          items.concat(page.value)
        end
        items
      end

      #
      # Gets the next page of results.
      #
      # @return [CognitiveServicesAccountListResult] with next page content.
      #
      def get_next_page
        response = @next_method.call(@next_link).value! unless @next_method.nil?
        unless response.nil?
          @next_link = response.body.next_link
          @value = response.body.value
          self
        end
      end

      #
      # Mapper for CognitiveServicesAccountListResult class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'CognitiveServicesAccountListResult',
          type: {
            name: 'Composite',
            class_name: 'CognitiveServicesAccountListResult',
            model_properties: {
              next_link: {
                required: false,
                serialized_name: 'nextLink',
                type: {
                  name: 'String'
                }
              },
              value: {
                required: false,
                read_only: true,
                serialized_name: 'value',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'CognitiveServicesAccountElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'CognitiveServicesAccount'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
