# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Commerce
  #
  # UsageAggregates
  #
  class UsageAggregates
    include MsRestAzure

    #
    # Creates and initializes a new instance of the UsageAggregates class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [UsageManagementClient] reference to the UsageManagementClient
    attr_reader :client

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param reported_start_time [DateTime] The start of the time range to retrieve
    # data for.
    # @param reported_end_time [DateTime] The end of the time range to retrieve
    # data for.
    # @param show_details [Boolean] `True` returns usage data in instance-level
    # detail, `false` causes server-side aggregation with fewer details. For
    # example, if you have 3 website instances, by default you will get 3 line
    # items for website consumption. If you specify showDetails = false, the data
    # will be aggregated as a single line item for website consumption within the
    # time period (for the given subscriptionId, meterId, usageStartTime and
    # usageEndTime).
    # @param aggregation_granularity [AggregationGranularity] `Daily` (default)
    # returns the data in daily granularity, `Hourly` returns the data in hourly
    # granularity. Possible values include: 'Daily', 'Hourly'
    # @param continuation_token [String] Used when a continuation token string is
    # provided in the response body of the previous call, enabling paging through a
    # large result set. If not present, the data is retrieved from the beginning of
    # the day/hour (based on the granularity) passed in.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<UsageAggregation>] operation results.
    #
    def list(reported_start_time, reported_end_time, show_details = nil, aggregation_granularity = nil, continuation_token = nil, custom_headers = nil)
      first_page = list_as_lazy(reported_start_time, reported_end_time, show_details, aggregation_granularity, continuation_token, custom_headers)
      first_page.get_all_items
    end

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param reported_start_time [DateTime] The start of the time range to retrieve
    # data for.
    # @param reported_end_time [DateTime] The end of the time range to retrieve
    # data for.
    # @param show_details [Boolean] `True` returns usage data in instance-level
    # detail, `false` causes server-side aggregation with fewer details. For
    # example, if you have 3 website instances, by default you will get 3 line
    # items for website consumption. If you specify showDetails = false, the data
    # will be aggregated as a single line item for website consumption within the
    # time period (for the given subscriptionId, meterId, usageStartTime and
    # usageEndTime).
    # @param aggregation_granularity [AggregationGranularity] `Daily` (default)
    # returns the data in daily granularity, `Hourly` returns the data in hourly
    # granularity. Possible values include: 'Daily', 'Hourly'
    # @param continuation_token [String] Used when a continuation token string is
    # provided in the response body of the previous call, enabling paging through a
    # large result set. If not present, the data is retrieved from the beginning of
    # the day/hour (based on the granularity) passed in.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(reported_start_time, reported_end_time, show_details = nil, aggregation_granularity = nil, continuation_token = nil, custom_headers = nil)
      list_async(reported_start_time, reported_end_time, show_details, aggregation_granularity, continuation_token, custom_headers).value!
    end

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param reported_start_time [DateTime] The start of the time range to retrieve
    # data for.
    # @param reported_end_time [DateTime] The end of the time range to retrieve
    # data for.
    # @param show_details [Boolean] `True` returns usage data in instance-level
    # detail, `false` causes server-side aggregation with fewer details. For
    # example, if you have 3 website instances, by default you will get 3 line
    # items for website consumption. If you specify showDetails = false, the data
    # will be aggregated as a single line item for website consumption within the
    # time period (for the given subscriptionId, meterId, usageStartTime and
    # usageEndTime).
    # @param aggregation_granularity [AggregationGranularity] `Daily` (default)
    # returns the data in daily granularity, `Hourly` returns the data in hourly
    # granularity. Possible values include: 'Daily', 'Hourly'
    # @param continuation_token [String] Used when a continuation token string is
    # provided in the response body of the previous call, enabling paging through a
    # large result set. If not present, the data is retrieved from the beginning of
    # the day/hour (based on the granularity) passed in.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(reported_start_time, reported_end_time, show_details = nil, aggregation_granularity = nil, continuation_token = nil, custom_headers = nil)
      fail ArgumentError, 'reported_start_time is nil' if reported_start_time.nil?
      fail ArgumentError, 'reported_end_time is nil' if reported_end_time.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Commerce/UsageAggregates'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'reportedStartTime' => reported_start_time,'reportedEndTime' => reported_end_time,'showDetails' => show_details,'aggregationGranularity' => aggregation_granularity,'continuationToken' => continuation_token,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Commerce::Models::UsageAggregationListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageAggregationListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Commerce::Models::UsageAggregationListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Query aggregated Azure subscription consumption data for a date range.
    #
    # @param reported_start_time [DateTime] The start of the time range to retrieve
    # data for.
    # @param reported_end_time [DateTime] The end of the time range to retrieve
    # data for.
    # @param show_details [Boolean] `True` returns usage data in instance-level
    # detail, `false` causes server-side aggregation with fewer details. For
    # example, if you have 3 website instances, by default you will get 3 line
    # items for website consumption. If you specify showDetails = false, the data
    # will be aggregated as a single line item for website consumption within the
    # time period (for the given subscriptionId, meterId, usageStartTime and
    # usageEndTime).
    # @param aggregation_granularity [AggregationGranularity] `Daily` (default)
    # returns the data in daily granularity, `Hourly` returns the data in hourly
    # granularity. Possible values include: 'Daily', 'Hourly'
    # @param continuation_token [String] Used when a continuation token string is
    # provided in the response body of the previous call, enabling paging through a
    # large result set. If not present, the data is retrieved from the beginning of
    # the day/hour (based on the granularity) passed in.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageAggregationListResult] which provide lazy access to pages of
    # the response.
    #
    def list_as_lazy(reported_start_time, reported_end_time, show_details = nil, aggregation_granularity = nil, continuation_token = nil, custom_headers = nil)
      response = list_async(reported_start_time, reported_end_time, show_details, aggregation_granularity, continuation_token, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
