# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Dns
  #
  # The DNS Management Client.
  #
  class Zones
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Zones class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DnsManagementClient] reference to the DnsManagementClient
    attr_reader :client

    #
    # Creates or updates a DNS zone. Does not modify DNS records within the zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param parameters [Zone] Parameters supplied to the CreateOrUpdate operation.
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # overwrite the current zone. Specify the last-seen etag value to prevent
    # accidentally overwritting any concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new DNS zone to be
    # created, but to prevent updating an existing zone. Other values will be
    # ignored.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Zone] operation results.
    #
    def create_or_update(resource_group_name, zone_name, parameters, if_match = nil, if_none_match = nil, custom_headers = nil)
      response = create_or_update_async(resource_group_name, zone_name, parameters, if_match, if_none_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a DNS zone. Does not modify DNS records within the zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param parameters [Zone] Parameters supplied to the CreateOrUpdate operation.
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # overwrite the current zone. Specify the last-seen etag value to prevent
    # accidentally overwritting any concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new DNS zone to be
    # created, but to prevent updating an existing zone. Other values will be
    # ignored.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, zone_name, parameters, if_match = nil, if_none_match = nil, custom_headers = nil)
      create_or_update_async(resource_group_name, zone_name, parameters, if_match, if_none_match, custom_headers).value!
    end

    #
    # Creates or updates a DNS zone. Does not modify DNS records within the zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param parameters [Zone] Parameters supplied to the CreateOrUpdate operation.
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # overwrite the current zone. Specify the last-seen etag value to prevent
    # accidentally overwritting any concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new DNS zone to be
    # created, but to prevent updating an existing zone. Other values will be
    # ignored.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, zone_name, parameters, if_match = nil, if_none_match = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['If-None-Match'] = if_none_match unless if_none_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Dns::Models::Zone.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::Zone.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::Zone.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a DNS zone. WARNING: All DNS records in the zone will also be
    # deleted. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # delete the current zone. Specify the last-seen etag value to prevent
    # accidentally deleting any concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ZoneDeleteResult] operation results.
    #
    def delete(resource_group_name, zone_name, if_match = nil, custom_headers = nil)
      response = delete_async(resource_group_name, zone_name, if_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # delete the current zone. Specify the last-seen etag value to prevent
    # accidentally deleting any concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, zone_name, if_match = nil, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, zone_name, if_match, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Dns::Models::ZoneDeleteResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a DNS zone. Retrieves the zone properties, but not the record sets
    # within the zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Zone] operation results.
    #
    def get(resource_group_name, zone_name, custom_headers = nil)
      response = get_async(resource_group_name, zone_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a DNS zone. Retrieves the zone properties, but not the record sets
    # within the zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, zone_name, custom_headers = nil)
      get_async(resource_group_name, zone_name, custom_headers).value!
    end

    #
    # Gets a DNS zone. Retrieves the zone properties, but not the record sets
    # within the zone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, zone_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::Zone.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Zone>] operation results.
    #
    def list_by_resource_group(resource_group_name, top = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, top, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, top = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, top, custom_headers).value!
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, top = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::ZoneListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param top [Integer] The maximum number of DNS zones to return. If not
    # specified, returns up to 100 zones.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Zone>] operation results.
    #
    def list(top = nil, custom_headers = nil)
      first_page = list_as_lazy(top, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param top [Integer] The maximum number of DNS zones to return. If not
    # specified, returns up to 100 zones.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(top = nil, custom_headers = nil)
      list_async(top, custom_headers).value!
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param top [Integer] The maximum number of DNS zones to return. If not
    # specified, returns up to 100 zones.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(top = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Network/dnszones'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'$top' => top,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::ZoneListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a DNS zone. WARNING: All DNS records in the zone will also be
    # deleted. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # delete the current zone. Specify the last-seen etag value to prevent
    # accidentally deleting any concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ZoneDeleteResult] operation results.
    #
    def begin_delete(resource_group_name, zone_name, if_match = nil, custom_headers = nil)
      response = begin_delete_async(resource_group_name, zone_name, if_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a DNS zone. WARNING: All DNS records in the zone will also be
    # deleted. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # delete the current zone. Specify the last-seen etag value to prevent
    # accidentally deleting any concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, zone_name, if_match = nil, custom_headers = nil)
      begin_delete_async(resource_group_name, zone_name, if_match, custom_headers).value!
    end

    #
    # Deletes a DNS zone. WARNING: All DNS records in the zone will also be
    # deleted. This operation cannot be undone.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param zone_name [String] The name of the DNS zone (without a terminating
    # dot).
    # @param if_match [String] The etag of the DNS zone. Omit this value to always
    # delete the current zone. Specify the last-seen etag value to prevent
    # accidentally deleting any concurrent changes.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, zone_name, if_match = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'zone_name is nil' if zone_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'zoneName' => zone_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::ZoneDeleteResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ZoneListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::ZoneListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ZoneListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Dns::Models::ZoneListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the DNS zones within a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param top [Integer] The maximum number of record sets to return. If not
    # specified, returns up to 100 record sets.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ZoneListResult] which provide lazy access to pages of the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, top = nil, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists the DNS zones in all resource groups in a subscription.
    #
    # @param top [Integer] The maximum number of DNS zones to return. If not
    # specified, returns up to 100 zones.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ZoneListResult] which provide lazy access to pages of the response.
    #
    def list_as_lazy(top = nil, custom_headers = nil)
      response = list_async(top, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
