# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Monitor
  module Models
    #
    # The alert rule object for patch operations.
    #
    class AlertRuleResourcePatch

      include MsRestAzure

      include MsRest::JSONable
      # @return [Hash{String => String}] Resource tags
      attr_accessor :tags

      # @return [String] the name of the alert rule.
      attr_accessor :name

      # @return [String] the description of the alert rule that will be
      # included in the alert email.
      attr_accessor :description

      # @return [Boolean] the flag that indicates whether the alert rule is
      # enabled.
      attr_accessor :is_enabled

      # @return [RuleCondition] the condition that results in the alert rule
      # being activated.
      attr_accessor :condition

      # @return [Array<RuleAction>] the array of actions that are performed
      # when the alert rule becomes active, and when an alert condition is
      # resolved.
      attr_accessor :actions

      # @return [DateTime] Last time the rule was updated in ISO8601 format.
      attr_accessor :last_updated_time


      #
      # Mapper for AlertRuleResourcePatch class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'AlertRuleResourcePatch',
          type: {
            name: 'Composite',
            class_name: 'AlertRuleResourcePatch',
            model_properties: {
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              name: {
                required: true,
                serialized_name: 'properties.name',
                type: {
                  name: 'String'
                }
              },
              description: {
                required: false,
                serialized_name: 'properties.description',
                type: {
                  name: 'String'
                }
              },
              is_enabled: {
                required: true,
                serialized_name: 'properties.isEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              condition: {
                required: true,
                serialized_name: 'properties.condition',
                type: {
                  name: 'Composite',
                  polymorphic_discriminator: 'odata.type',
                  uber_parent: 'RuleCondition',
                  class_name: 'RuleCondition'
                }
              },
              actions: {
                required: false,
                serialized_name: 'properties.actions',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'RuleActionElementType',
                      type: {
                        name: 'Composite',
                        polymorphic_discriminator: 'odata.type',
                        uber_parent: 'RuleAction',
                        class_name: 'RuleAction'
                      }
                  }
                }
              },
              last_updated_time: {
                required: false,
                read_only: true,
                serialized_name: 'properties.lastUpdatedTime',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
