# encoding: utf-8
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # The resource storage details.
    #
    class BackupResourceConfig

      include MsRestAzure

      include MsRest::JSONable
      # @return [StorageType] Storage type. Possible values include: 'Invalid',
      # 'GeoRedundant', 'LocallyRedundant'
      attr_accessor :storage_type

      # @return [StorageTypeState] Locked or Unlocked. Once a machine is
      # registered against a resource, the storageTypeState is always Locked.
      # Possible values include: 'Invalid', 'Locked', 'Unlocked'
      attr_accessor :storage_type_state


      #
      # Mapper for BackupResourceConfig class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'BackupResourceConfig',
          type: {
            name: 'Composite',
            class_name: 'BackupResourceConfig',
            model_properties: {
              storage_type: {
                required: false,
                serialized_name: 'storageType',
                type: {
                  name: 'String'
                }
              },
              storage_type_state: {
                required: false,
                serialized_name: 'storageTypeState',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
