# encoding: utf-8
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # Additional information for the MAB workload-specific job.
    #
    class MabJobExtendedInfo

      include MsRestAzure

      include MsRest::JSONable
      # @return [Array<MabJobTaskDetails>] List of tasks for this job.
      attr_accessor :tasks_list

      # @return [Hash{String => String}] The job properties.
      attr_accessor :property_bag

      # @return [String] Non localized error message specific to this job.
      attr_accessor :dynamic_error_message


      #
      # Mapper for MabJobExtendedInfo class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'MabJobExtendedInfo',
          type: {
            name: 'Composite',
            class_name: 'MabJobExtendedInfo',
            model_properties: {
              tasks_list: {
                required: false,
                serialized_name: 'tasksList',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'MabJobTaskDetailsElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'MabJobTaskDetails'
                      }
                  }
                }
              },
              property_bag: {
                required: false,
                serialized_name: 'propertyBag',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              dynamic_error_message: {
                required: false,
                serialized_name: 'dynamicErrorMessage',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
