# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServerManagement
  #
  # REST API for Azure Server Management Service.
  #
  class PowerShell
    include MsRestAzure

    #
    # Creates and initializes a new instance of the PowerShell class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ServerManagement] reference to the ServerManagement
    attr_reader :client

    #
    # Gets a list of the active sessions.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellSessionResources] operation results.
    #
    def list_session(resource_group_name, node_name, session, custom_headers = nil)
      response = list_session_async(resource_group_name, node_name, session, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of the active sessions.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_session_with_http_info(resource_group_name, node_name, session, custom_headers = nil)
      list_session_async(resource_group_name, node_name, session, custom_headers).value!
    end

    #
    # Gets a list of the active sessions.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_session_async(resource_group_name, node_name, session, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellSessionResources.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a PowerShell session.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellSessionResource] operation results.
    #
    def create_session(resource_group_name, node_name, session, pssession, custom_headers = nil)
      response = create_session_async(resource_group_name, node_name, session, pssession, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_session_async(resource_group_name, node_name, session, pssession, custom_headers = nil)
      # Send request
      promise = begin_create_session_async(resource_group_name, node_name, session, pssession, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::ServerManagement::Models::PowerShellSessionResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the status of a command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param expand [PowerShellExpandOption] Gets current output from an ongoing
    # call. Possible values include: 'output'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandStatus] operation results.
    #
    def get_command_status(resource_group_name, node_name, session, pssession, expand = nil, custom_headers = nil)
      response = get_command_status_async(resource_group_name, node_name, session, pssession, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the status of a command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param expand [PowerShellExpandOption] Gets current output from an ongoing
    # call. Possible values include: 'output'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_command_status_with_http_info(resource_group_name, node_name, session, pssession, expand = nil, custom_headers = nil)
      get_command_status_async(resource_group_name, node_name, session, pssession, expand, custom_headers).value!
    end

    #
    # Gets the status of a command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param expand [PowerShellExpandOption] Gets current output from an ongoing
    # call. Possible values include: 'output'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_command_status_async(resource_group_name, node_name, session, pssession, expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?
      fail ArgumentError, 'pssession is nil' if pssession.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session,'pssession' => pssession},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandStatus.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a running PowerShell command with more data.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandResults] operation results.
    #
    def update_command(resource_group_name, node_name, session, pssession, custom_headers = nil)
      response = update_command_async(resource_group_name, node_name, session, pssession, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_command_async(resource_group_name, node_name, session, pssession, custom_headers = nil)
      # Send request
      promise = begin_update_command_async(resource_group_name, node_name, session, pssession, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandResults.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates a PowerShell script and invokes it.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Script to execute.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandResults] operation results.
    #
    def invoke_command(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      response = invoke_command_async(resource_group_name, node_name, session, pssession, command, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Script to execute.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def invoke_command_async(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      # Send request
      promise = begin_invoke_command_async(resource_group_name, node_name, session, pssession, command, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandResults.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Cancels a PowerShell command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandResults] operation results.
    #
    def cancel_command(resource_group_name, node_name, session, pssession, custom_headers = nil)
      response = cancel_command_async(resource_group_name, node_name, session, pssession, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def cancel_command_async(resource_group_name, node_name, session, pssession, custom_headers = nil)
      # Send request
      promise = begin_cancel_command_async(resource_group_name, node_name, session, pssession, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandResults.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets tab completion values for a command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Command to get tab completion for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellTabCompletionResults] operation results.
    #
    def tab_completion(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      response = tab_completion_async(resource_group_name, node_name, session, pssession, command, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets tab completion values for a command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Command to get tab completion for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def tab_completion_with_http_info(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      tab_completion_async(resource_group_name, node_name, session, pssession, command, custom_headers).value!
    end

    #
    # Gets tab completion values for a command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Command to get tab completion for.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def tab_completion_async(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?
      fail ArgumentError, 'pssession is nil' if pssession.nil?

      power_shell_tab_completion_paramters = PowerShellTabCompletionParameters.new
      unless command.nil?
        power_shell_tab_completion_paramters.command = command
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::ServerManagement::Models::PowerShellTabCompletionParameters.mapper()
      request_content = @client.serialize(request_mapper,  power_shell_tab_completion_paramters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}/tab'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session,'pssession' => pssession},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellTabCompletionResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a PowerShell session.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellSessionResource] operation results.
    #
    def begin_create_session(resource_group_name, node_name, session, pssession, custom_headers = nil)
      response = begin_create_session_async(resource_group_name, node_name, session, pssession, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a PowerShell session.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_session_with_http_info(resource_group_name, node_name, session, pssession, custom_headers = nil)
      begin_create_session_async(resource_group_name, node_name, session, pssession, custom_headers).value!
    end

    #
    # Creates a PowerShell session.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_session_async(resource_group_name, node_name, session, pssession, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?
      fail ArgumentError, 'pssession is nil' if pssession.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session,'pssession' => pssession},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellSessionResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates a running PowerShell command with more data.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandResults] operation results.
    #
    def begin_update_command(resource_group_name, node_name, session, pssession, custom_headers = nil)
      response = begin_update_command_async(resource_group_name, node_name, session, pssession, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a running PowerShell command with more data.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_command_with_http_info(resource_group_name, node_name, session, pssession, custom_headers = nil)
      begin_update_command_async(resource_group_name, node_name, session, pssession, custom_headers).value!
    end

    #
    # Updates a running PowerShell command with more data.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_command_async(resource_group_name, node_name, session, pssession, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?
      fail ArgumentError, 'pssession is nil' if pssession.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session,'pssession' => pssession},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a PowerShell script and invokes it.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Script to execute.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandResults] operation results.
    #
    def begin_invoke_command(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      response = begin_invoke_command_async(resource_group_name, node_name, session, pssession, command, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a PowerShell script and invokes it.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Script to execute.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_invoke_command_with_http_info(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      begin_invoke_command_async(resource_group_name, node_name, session, pssession, command, custom_headers).value!
    end

    #
    # Creates a PowerShell script and invokes it.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param command [String] Script to execute.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_invoke_command_async(resource_group_name, node_name, session, pssession, command = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?
      fail ArgumentError, 'pssession is nil' if pssession.nil?

      power_shell_command_parameters = PowerShellCommandParameters.new
      unless command.nil?
        power_shell_command_parameters.command = command
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandParameters.mapper()
      request_content = @client.serialize(request_mapper,  power_shell_command_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}/invokeCommand'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session,'pssession' => pssession},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Cancels a PowerShell command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PowerShellCommandResults] operation results.
    #
    def begin_cancel_command(resource_group_name, node_name, session, pssession, custom_headers = nil)
      response = begin_cancel_command_async(resource_group_name, node_name, session, pssession, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Cancels a PowerShell command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_cancel_command_with_http_info(resource_group_name, node_name, session, pssession, custom_headers = nil)
      begin_cancel_command_async(resource_group_name, node_name, session, pssession, custom_headers).value!
    end

    #
    # Cancels a PowerShell command.
    #
    # @param resource_group_name [String] The resource group name uniquely
    # identifies the resource group within the user subscriptionId.
    # @param node_name [String] The node name (256 characters maximum).
    # @param session [String] The sessionId from the user.
    # @param pssession [String] The PowerShell sessionId from the user.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_cancel_command_async(resource_group_name, node_name, session, pssession, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'node_name is nil' if node_name.nil?
      fail ArgumentError, 'session is nil' if session.nil?
      fail ArgumentError, 'pssession is nil' if pssession.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServerManagement/nodes/{nodeName}/sessions/{session}/features/powerShellConsole/pssessions/{pssession}/cancel'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'nodeName' => node_name,'session' => session,'pssession' => pssession},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServerManagement::Models::PowerShellCommandResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
