# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServiceBus
  module Models
    #
    # Description of topic resource.
    #
    class SBTopic < MsRestAzure::Resource

      include MsRestAzure

      include MsRest::JSONable
      # @return [Integer] Size of the topic, in bytes.
      attr_accessor :size_in_bytes

      # @return [DateTime] Exact time the message was created.
      attr_accessor :created_at

      # @return [DateTime] The exact time the message was updated.
      attr_accessor :updated_at

      # @return [DateTime] Last time the message was sent, or a request was
      # received, for this topic.
      attr_accessor :accessed_at

      # @return [Integer] Number of subscriptions.
      attr_accessor :subscription_count

      # @return [MessageCountDetails] Message count deatils
      attr_accessor :count_details

      # @return [Duration] ISO 8601 Default message timespan to live value.
      # This is the duration after which the message expires, starting from
      # when the message is sent to Service Bus. This is the default value used
      # when TimeToLive is not set on a message itself.
      attr_accessor :default_message_time_to_live

      # @return [Integer] Maximum size of the topic in megabytes, which is the
      # size of the memory allocated for the topic. Default is 1024.
      attr_accessor :max_size_in_megabytes

      # @return [Boolean] Value indicating if this topic requires duplicate
      # detection.
      attr_accessor :requires_duplicate_detection

      # @return [Duration] ISO8601 timespan structure that defines the duration
      # of the duplicate detection history. The default value is 10 minutes.
      attr_accessor :duplicate_detection_history_time_window

      # @return [Boolean] Value that indicates whether server-side batched
      # operations are enabled.
      attr_accessor :enable_batched_operations

      # @return [EntityStatus] Enumerates the possible values for the status of
      # a messaging entity. Possible values include: 'Active', 'Disabled',
      # 'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting',
      # 'Renaming', 'Unknown'
      attr_accessor :status

      # @return [Boolean] Value that indicates whether the topic supports
      # ordering.
      attr_accessor :support_ordering

      # @return [Duration] ISO 8601 timespan idle interval after which the
      # topic is automatically deleted. The minimum duration is 5 minutes.
      attr_accessor :auto_delete_on_idle

      # @return [Boolean] Value that indicates whether the topic to be
      # partitioned across multiple message brokers is enabled.
      attr_accessor :enable_partitioning

      # @return [Boolean] Value that indicates whether Express Entities are
      # enabled. An express topic holds a message in memory temporarily before
      # writing it to persistent storage.
      attr_accessor :enable_express


      #
      # Mapper for SBTopic class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'SBTopic',
          type: {
            name: 'Composite',
            class_name: 'SBTopic',
            model_properties: {
              id: {
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              size_in_bytes: {
                required: false,
                read_only: true,
                serialized_name: 'properties.sizeInBytes',
                type: {
                  name: 'Number'
                }
              },
              created_at: {
                required: false,
                read_only: true,
                serialized_name: 'properties.createdAt',
                type: {
                  name: 'DateTime'
                }
              },
              updated_at: {
                required: false,
                read_only: true,
                serialized_name: 'properties.updatedAt',
                type: {
                  name: 'DateTime'
                }
              },
              accessed_at: {
                required: false,
                read_only: true,
                serialized_name: 'properties.accessedAt',
                type: {
                  name: 'DateTime'
                }
              },
              subscription_count: {
                required: false,
                read_only: true,
                serialized_name: 'properties.subscriptionCount',
                type: {
                  name: 'Number'
                }
              },
              count_details: {
                required: false,
                read_only: true,
                serialized_name: 'properties.countDetails',
                type: {
                  name: 'Composite',
                  class_name: 'MessageCountDetails'
                }
              },
              default_message_time_to_live: {
                required: false,
                serialized_name: 'properties.defaultMessageTimeToLive',
                type: {
                  name: 'TimeSpan'
                }
              },
              max_size_in_megabytes: {
                required: false,
                serialized_name: 'properties.maxSizeInMegabytes',
                type: {
                  name: 'Number'
                }
              },
              requires_duplicate_detection: {
                required: false,
                serialized_name: 'properties.requiresDuplicateDetection',
                type: {
                  name: 'Boolean'
                }
              },
              duplicate_detection_history_time_window: {
                required: false,
                serialized_name: 'properties.duplicateDetectionHistoryTimeWindow',
                type: {
                  name: 'TimeSpan'
                }
              },
              enable_batched_operations: {
                required: false,
                serialized_name: 'properties.enableBatchedOperations',
                type: {
                  name: 'Boolean'
                }
              },
              status: {
                required: false,
                serialized_name: 'properties.status',
                type: {
                  name: 'Enum',
                  module: 'EntityStatus'
                }
              },
              support_ordering: {
                required: false,
                serialized_name: 'properties.supportOrdering',
                type: {
                  name: 'Boolean'
                }
              },
              auto_delete_on_idle: {
                required: false,
                serialized_name: 'properties.autoDeleteOnIdle',
                type: {
                  name: 'TimeSpan'
                }
              },
              enable_partitioning: {
                required: false,
                serialized_name: 'properties.enablePartitioning',
                type: {
                  name: 'Boolean'
                }
              },
              enable_express: {
                required: false,
                serialized_name: 'properties.enableExpress',
                type: {
                  name: 'Boolean'
                }
              }
            }
          }
        }
      end
    end
  end
end
