# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServiceBus
  #
  # Azure Service Bus client
  #
  class Queues
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Queues class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ServiceBusManagementClient] reference to the ServiceBusManagementClient
    attr_reader :client

    #
    # Gets the queues within a namespace.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SBQueue>] operation results.
    #
    def list_by_namespace(resource_group_name, namespace_name, custom_headers = nil)
      first_page = list_by_namespace_as_lazy(resource_group_name, namespace_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the queues within a namespace.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_namespace_with_http_info(resource_group_name, namespace_name, custom_headers = nil)
      list_by_namespace_async(resource_group_name, namespace_name, custom_headers).value!
    end

    #
    # Gets the queues within a namespace.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_namespace_async(resource_group_name, namespace_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBQueueListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates or updates a Service Bus queue. This operation is idempotent.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param parameters [SBQueue] Parameters supplied to create or update a queue
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBQueue] operation results.
    #
    def create_or_update(resource_group_name, namespace_name, queue_name, parameters, custom_headers = nil)
      response = create_or_update_async(resource_group_name, namespace_name, queue_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a Service Bus queue. This operation is idempotent.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param parameters [SBQueue] Parameters supplied to create or update a queue
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, namespace_name, queue_name, parameters, custom_headers = nil)
      create_or_update_async(resource_group_name, namespace_name, queue_name, parameters, custom_headers).value!
    end

    #
    # Creates or updates a Service Bus queue. This operation is idempotent.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param parameters [SBQueue] Parameters supplied to create or update a queue
    # resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, namespace_name, queue_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::ServiceBus::Models::SBQueue.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBQueue.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a queue from the specified namespace in a resource group.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      response = delete_async(resource_group_name, namespace_name, queue_name, custom_headers).value!
      nil
    end

    #
    # Deletes a queue from the specified namespace in a resource group.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      delete_async(resource_group_name, namespace_name, queue_name, custom_headers).value!
    end

    #
    # Deletes a queue from the specified namespace in a resource group.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Returns a description for the specified queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBQueue] operation results.
    #
    def get(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      response = get_async(resource_group_name, namespace_name, queue_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns a description for the specified queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      get_async(resource_group_name, namespace_name, queue_name, custom_headers).value!
    end

    #
    # Returns a description for the specified queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBQueue.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SBAuthorizationRule>] operation results.
    #
    def list_authorization_rules(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      first_page = list_authorization_rules_as_lazy(resource_group_name, namespace_name, queue_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_authorization_rules_with_http_info(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      list_authorization_rules_async(resource_group_name, namespace_name, queue_name, custom_headers).value!
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_authorization_rules_async(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBAuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates an authorization rule for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param parameters [SBAuthorizationRule] The shared access authorization rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBAuthorizationRule] operation results.
    #
    def create_or_update_authorization_rule(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers = nil)
      response = create_or_update_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates an authorization rule for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param parameters [SBAuthorizationRule] The shared access authorization rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_authorization_rule_with_http_info(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers = nil)
      create_or_update_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers).value!
    end

    #
    # Creates an authorization rule for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param parameters [SBAuthorizationRule] The shared access authorization rule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::ServiceBus::Models::SBAuthorizationRule.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBAuthorizationRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a queue authorization rule.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_authorization_rule(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      response = delete_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers).value!
      nil
    end

    #
    # Deletes a queue authorization rule.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_authorization_rule_with_http_info(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      delete_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Deletes a queue authorization rule.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets an authorization rule for a queue by rule name.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBAuthorizationRule] operation results.
    #
    def get_authorization_rule(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      response = get_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an authorization rule for a queue by rule name.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_authorization_rule_with_http_info(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      get_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Gets an authorization rule for a queue by rule name.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_authorization_rule_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBAuthorizationRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Primary and secondary connection strings to the queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AccessKeys] operation results.
    #
    def list_keys(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      response = list_keys_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Primary and secondary connection strings to the queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_with_http_info(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      list_keys_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Primary and secondary connection strings to the queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}/ListKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::AccessKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Regenerates the primary or secondary connection strings to the queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param parameters [RegenerateAccessKeyParameters] Parameters supplied to
    # regenerate the authorization rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AccessKeys] operation results.
    #
    def regenerate_keys(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers = nil)
      response = regenerate_keys_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Regenerates the primary or secondary connection strings to the queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param parameters [RegenerateAccessKeyParameters] Parameters supplied to
    # regenerate the authorization rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def regenerate_keys_with_http_info(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers = nil)
      regenerate_keys_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers).value!
    end

    #
    # Regenerates the primary or secondary connection strings to the queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param authorization_rule_name [String] The authorizationrule name.
    # @param parameters [RegenerateAccessKeyParameters] Parameters supplied to
    # regenerate the authorization rule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def regenerate_keys_async(resource_group_name, namespace_name, queue_name, authorization_rule_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'queue_name is nil' if queue_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::ServiceBus::Models::RegenerateAccessKeyParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}/authorizationRules/{authorizationRuleName}/regenerateKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'queueName' => queue_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::AccessKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the queues within a namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBQueueListResult] operation results.
    #
    def list_by_namespace_next(next_page_link, custom_headers = nil)
      response = list_by_namespace_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the queues within a namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_namespace_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_namespace_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the queues within a namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_namespace_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBQueueListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBAuthorizationRuleListResult] operation results.
    #
    def list_authorization_rules_next(next_page_link, custom_headers = nil)
      response = list_authorization_rules_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_authorization_rules_next_with_http_info(next_page_link, custom_headers = nil)
      list_authorization_rules_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_authorization_rules_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::ServiceBus::Models::SBAuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the queues within a namespace.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBQueueListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_namespace_as_lazy(resource_group_name, namespace_name, custom_headers = nil)
      response = list_by_namespace_async(resource_group_name, namespace_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_namespace_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets all authorization rules for a queue.
    #
    # @param resource_group_name [String] Name of the Resource group within the
    # Azure subscription.
    # @param namespace_name [String] The namespace name
    # @param queue_name [String] The queue name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SBAuthorizationRuleListResult] which provide lazy access to pages of
    # the response.
    #
    def list_authorization_rules_as_lazy(resource_group_name, namespace_name, queue_name, custom_headers = nil)
      response = list_authorization_rules_async(resource_group_name, namespace_name, queue_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_authorization_rules_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
