# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::StreamAnalytics
  module Models
    #
    # Describes an Event Hub input data source that contains stream data.
    #
    class EventHubStreamInputDataSource < StreamInputDataSource

      include MsRestAzure

      include MsRest::JSONable

      def initialize
        @type = "Microsoft.ServiceBus/EventHub"
      end

      attr_accessor :type

      # @return [String] The namespace that is associated with the desired
      # Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT
      # (CreateOrReplace) requests.
      attr_accessor :service_bus_namespace

      # @return [String] The shared access policy name for the Event Hub,
      # Service Bus Queue, Service Bus Topic, etc. Required on PUT
      # (CreateOrReplace) requests.
      attr_accessor :shared_access_policy_name

      # @return [String] The shared access policy key for the specified shared
      # access policy. Required on PUT (CreateOrReplace) requests.
      attr_accessor :shared_access_policy_key

      # @return [String] The name of the Event Hub. Required on PUT
      # (CreateOrReplace) requests.
      attr_accessor :event_hub_name

      # @return [String] The name of an Event Hub Consumer Group that should be
      # used to read events from the Event Hub. Specifying distinct consumer
      # group names for multiple inputs allows each of those inputs to receive
      # the same events from the Event Hub. If not specified, the input uses
      # the Event Hub’s default consumer group.
      attr_accessor :consumer_group_name


      #
      # Mapper for EventHubStreamInputDataSource class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'Microsoft.ServiceBus/EventHub',
          type: {
            name: 'Composite',
            class_name: 'EventHubStreamInputDataSource',
            model_properties: {
              type: {
                required: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              service_bus_namespace: {
                required: false,
                serialized_name: 'properties.serviceBusNamespace',
                type: {
                  name: 'String'
                }
              },
              shared_access_policy_name: {
                required: false,
                serialized_name: 'properties.sharedAccessPolicyName',
                type: {
                  name: 'String'
                }
              },
              shared_access_policy_key: {
                required: false,
                serialized_name: 'properties.sharedAccessPolicyKey',
                type: {
                  name: 'String'
                }
              },
              event_hub_name: {
                required: false,
                serialized_name: 'properties.eventHubName',
                type: {
                  name: 'String'
                }
              },
              consumer_group_name: {
                required: false,
                serialized_name: 'properties.consumerGroupName',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
