# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::StreamAnalytics
  #
  # Stream Analytics Client
  #
  class StreamingJobs
    include MsRestAzure

    #
    # Creates and initializes a new instance of the StreamingJobs class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [StreamAnalyticsManagementClient] reference to the StreamAnalyticsManagementClient
    attr_reader :client

    #
    # Creates a streaming job or replaces an already existing streaming job.
    #
    # @param streaming_job [StreamingJob] The definition of the streaming job that
    # will be used to create a new streaming job or replace the existing one.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new streaming job to be
    # created, but to prevent updating an existing record set. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJob] operation results.
    #
    def create_or_replace(streaming_job, resource_group_name, job_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      response = create_or_replace_async(streaming_job, resource_group_name, job_name, if_match, if_none_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param streaming_job [StreamingJob] The definition of the streaming job that
    # will be used to create a new streaming job or replace the existing one.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new streaming job to be
    # created, but to prevent updating an existing record set. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_replace_async(streaming_job, resource_group_name, job_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_replace_async(streaming_job, resource_group_name, job_name, if_match, if_none_match, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates an existing streaming job. This can be used to partially update (ie.
    # update one or two properties) a streaming job without affecting the rest the
    # job definition.
    #
    # @param streaming_job [StreamingJob] A streaming job object. The properties
    # specified here will overwrite the corresponding properties in the existing
    # streaming job (ie. Those properties will be updated). Any properties that are
    # set to null here will mean that the corresponding property in the existing
    # input will remain the same and not change as a result of this PATCH
    # operation.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJob] operation results.
    #
    def update(streaming_job, resource_group_name, job_name, if_match = nil, custom_headers = nil)
      response = update_async(streaming_job, resource_group_name, job_name, if_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates an existing streaming job. This can be used to partially update (ie.
    # update one or two properties) a streaming job without affecting the rest the
    # job definition.
    #
    # @param streaming_job [StreamingJob] A streaming job object. The properties
    # specified here will overwrite the corresponding properties in the existing
    # streaming job (ie. Those properties will be updated). Any properties that are
    # set to null here will mean that the corresponding property in the existing
    # input will remain the same and not change as a result of this PATCH
    # operation.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(streaming_job, resource_group_name, job_name, if_match = nil, custom_headers = nil)
      update_async(streaming_job, resource_group_name, job_name, if_match, custom_headers).value!
    end

    #
    # Updates an existing streaming job. This can be used to partially update (ie.
    # update one or two properties) a streaming job without affecting the rest the
    # job definition.
    #
    # @param streaming_job [StreamingJob] A streaming job object. The properties
    # specified here will overwrite the corresponding properties in the existing
    # streaming job (ie. Those properties will be updated). Any properties that are
    # set to null here will mean that the corresponding property in the existing
    # input will remain the same and not change as a result of this PATCH
    # operation.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(streaming_job, resource_group_name, job_name, if_match = nil, custom_headers = nil)
      fail ArgumentError, 'streaming_job is nil' if streaming_job.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
      request_content = @client.serialize(request_mapper,  streaming_job)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, job_name, custom_headers = nil)
      response = delete_async(resource_group_name, job_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, job_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, job_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets details about the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJob] operation results.
    #
    def get(resource_group_name, job_name, expand = nil, custom_headers = nil)
      response = get_async(resource_group_name, job_name, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets details about the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, job_name, expand = nil, custom_headers = nil)
      get_async(resource_group_name, job_name, expand, custom_headers).value!
    end

    #
    # Gets details about the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, job_name, expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StreamingJob>] operation results.
    #
    def list_by_resource_group(resource_group_name, expand = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, expand, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, expand = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, expand, custom_headers).value!
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJobListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StreamingJob>] operation results.
    #
    def list(expand = nil, custom_headers = nil)
      first_page = list_as_lazy(expand, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(expand = nil, custom_headers = nil)
      list_async(expand, custom_headers).value!
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.StreamAnalytics/streamingjobs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJobListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Starts a streaming job. Once a job is started it will start processing input
    # events and produce output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param start_job_parameters [StartStreamingJobParameters] Parameters
    # applicable to a start streaming job operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def start(resource_group_name, job_name, start_job_parameters = nil, custom_headers = nil)
      response = start_async(resource_group_name, job_name, start_job_parameters, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param start_job_parameters [StartStreamingJobParameters] Parameters
    # applicable to a start streaming job operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, job_name, start_job_parameters = nil, custom_headers = nil)
      # Send request
      promise = begin_start_async(resource_group_name, job_name, start_job_parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Stops a running streaming job. This will cause a running streaming job to
    # stop processing input events and producing output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def stop(resource_group_name, job_name, custom_headers = nil)
      response = stop_async(resource_group_name, job_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def stop_async(resource_group_name, job_name, custom_headers = nil)
      # Send request
      promise = begin_stop_async(resource_group_name, job_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates a streaming job or replaces an already existing streaming job.
    #
    # @param streaming_job [StreamingJob] The definition of the streaming job that
    # will be used to create a new streaming job or replace the existing one.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new streaming job to be
    # created, but to prevent updating an existing record set. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJob] operation results.
    #
    def begin_create_or_replace(streaming_job, resource_group_name, job_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      response = begin_create_or_replace_async(streaming_job, resource_group_name, job_name, if_match, if_none_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a streaming job or replaces an already existing streaming job.
    #
    # @param streaming_job [StreamingJob] The definition of the streaming job that
    # will be used to create a new streaming job or replace the existing one.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new streaming job to be
    # created, but to prevent updating an existing record set. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_replace_with_http_info(streaming_job, resource_group_name, job_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      begin_create_or_replace_async(streaming_job, resource_group_name, job_name, if_match, if_none_match, custom_headers).value!
    end

    #
    # Creates a streaming job or replaces an already existing streaming job.
    #
    # @param streaming_job [StreamingJob] The definition of the streaming job that
    # will be used to create a new streaming job or replace the existing one.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param if_match [String] The ETag of the streaming job. Omit this value to
    # always overwrite the current record set. Specify the last-seen ETag value to
    # prevent accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new streaming job to be
    # created, but to prevent updating an existing record set. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_replace_async(streaming_job, resource_group_name, job_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      fail ArgumentError, 'streaming_job is nil' if streaming_job.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['If-None-Match'] = if_none_match unless if_none_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
      request_content = @client.serialize(request_mapper,  streaming_job)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJob.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, job_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, job_name, custom_headers).value!
      nil
    end

    #
    # Deletes a streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, job_name, custom_headers = nil)
      begin_delete_async(resource_group_name, job_name, custom_headers).value!
    end

    #
    # Deletes a streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, job_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts a streaming job. Once a job is started it will start processing input
    # events and produce output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param start_job_parameters [StartStreamingJobParameters] Parameters
    # applicable to a start streaming job operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_start(resource_group_name, job_name, start_job_parameters = nil, custom_headers = nil)
      response = begin_start_async(resource_group_name, job_name, start_job_parameters, custom_headers).value!
      nil
    end

    #
    # Starts a streaming job. Once a job is started it will start processing input
    # events and produce output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param start_job_parameters [StartStreamingJobParameters] Parameters
    # applicable to a start streaming job operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, job_name, start_job_parameters = nil, custom_headers = nil)
      begin_start_async(resource_group_name, job_name, start_job_parameters, custom_headers).value!
    end

    #
    # Starts a streaming job. Once a job is started it will start processing input
    # events and produce output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param start_job_parameters [StartStreamingJobParameters] Parameters
    # applicable to a start streaming job operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, job_name, start_job_parameters = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::StartStreamingJobParameters.mapper()
      request_content = @client.serialize(request_mapper,  start_job_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops a running streaming job. This will cause a running streaming job to
    # stop processing input events and producing output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_stop(resource_group_name, job_name, custom_headers = nil)
      response = begin_stop_async(resource_group_name, job_name, custom_headers).value!
      nil
    end

    #
    # Stops a running streaming job. This will cause a running streaming job to
    # stop processing input events and producing output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_stop_with_http_info(resource_group_name, job_name, custom_headers = nil)
      begin_stop_async(resource_group_name, job_name, custom_headers).value!
    end

    #
    # Stops a running streaming job. This will cause a running streaming job to
    # stop processing input events and producing output.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_stop_async(resource_group_name, job_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJobListResult] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJobListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJobListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::StreamingJobListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the streaming jobs in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJobListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, expand = nil, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, expand, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists all of the streaming jobs in the given subscription.
    #
    # @param expand [String] The $expand OData query parameter. This is a
    # comma-separated list of additional streaming job properties to include in the
    # response, beyond the default set returned when this parameter is absent. The
    # default set is all streaming job properties other than 'inputs',
    # 'transformation', 'outputs', and 'functions'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StreamingJobListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(expand = nil, custom_headers = nil)
      response = list_async(expand, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
