# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Represents a recommendation rule that the recommendation engine can
    # perform.
    #
    class RecommendationRule

      include MsRestAzure

      include MsRest::JSONable
      # @return [String] Unique name of the rule.
      attr_accessor :name

      # @return [String] UI friendly name of the rule.
      attr_accessor :display_name

      # @return [String] Localized name of the rule (Good for UI).
      attr_accessor :message

      # @return Recommendation ID of an associated recommendation object tied
      # to the rule, if exists.
      # If such an object doesn't exist, it is set to null.
      attr_accessor :recommendation_id

      # @return [String] Localized detailed description of the rule.
      attr_accessor :description

      # @return [String] Name of action that is recommended by this rule in
      # string.
      attr_accessor :action_name

      # @return [NotificationLevel] Level of impact indicating how critical
      # this rule is. Possible values include: 'Critical', 'Warning',
      # 'Information', 'NonUrgentSuggestion'
      attr_accessor :level

      # @return [Channels] List of available channels that this rule applies.
      # Possible values include: 'Notification', 'Api', 'Email', 'Webhook',
      # 'All'
      attr_accessor :channels

      # @return [Array<String>] An array of category tags that the rule
      # contains.
      attr_accessor :tags

      # @return [Boolean] True if this is associated with a dynamically added
      # rule
      attr_accessor :is_dynamic

      # @return [String] Extension name of the portal if exists. Applicable to
      # dynamic rule only.
      attr_accessor :extension_name

      # @return [String] Deep link to a blade on the portal. Applicable to
      # dynamic rule only.
      attr_accessor :blade_name

      # @return [String] Forward link to an external document associated with
      # the rule. Applicable to dynamic rule only.
      attr_accessor :forward_link


      #
      # Mapper for RecommendationRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'RecommendationRule',
          type: {
            name: 'Composite',
            class_name: 'RecommendationRule',
            model_properties: {
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              display_name: {
                required: false,
                serialized_name: 'displayName',
                type: {
                  name: 'String'
                }
              },
              message: {
                required: false,
                serialized_name: 'message',
                type: {
                  name: 'String'
                }
              },
              recommendation_id: {
                required: false,
                serialized_name: 'recommendationId',
                type: {
                  name: 'String'
                }
              },
              description: {
                required: false,
                serialized_name: 'description',
                type: {
                  name: 'String'
                }
              },
              action_name: {
                required: false,
                serialized_name: 'actionName',
                type: {
                  name: 'String'
                }
              },
              level: {
                required: false,
                serialized_name: 'level',
                type: {
                  name: 'Enum',
                  module: 'NotificationLevel'
                }
              },
              channels: {
                required: false,
                serialized_name: 'channels',
                type: {
                  name: 'Enum',
                  module: 'Channels'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              is_dynamic: {
                required: false,
                serialized_name: 'isDynamic',
                type: {
                  name: 'Boolean'
                }
              },
              extension_name: {
                required: false,
                serialized_name: 'extensionName',
                type: {
                  name: 'String'
                }
              },
              blade_name: {
                required: false,
                serialized_name: 'bladeName',
                type: {
                  name: 'String'
                }
              },
              forward_link: {
                required: false,
                serialized_name: 'forwardLink',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
