/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CSelectableRowList.h
    \author Romain BONDUE
    \date 29/07/2005 */
#ifndef __CSELECTABLEROWLIST_H__
#define __CSELECTABLEROWLIST_H__

#include <vector>
#include <string>

extern "C"{
#include <gtk/gtk.h>
}



namespace nsGUI
{
    class CGtkGUI;

    typedef bool (CGtkGUI::*GUICallBack) (unsigned);


        // A graphic component, the first column is always a button.
    class CSelectableRowList
    {
      public :
          // Only basic ::GType are allowed.
        CSelectableRowList (unsigned, const ::GType*, const char**, CGtkGUI*,
                            GUICallBack) throw();
        virtual ~CSelectableRowList () throw();
        operator ::GtkWidget* () throw();

        void SetData (unsigned Row, unsigned Column, bool) throw();
        void SetData (unsigned Row, unsigned Column, unsigned) throw();
        void SetData (unsigned Row, unsigned Column, int) throw();
        void SetData (unsigned Row, unsigned Column, float) throw();
        void SetData (unsigned Row, unsigned Column, const std::string&)
                                                                    throw();
        void Clear () throw();
        void DeleteRow (unsigned) throw();
        /** \return The selected row, 'None' if none. */
        int GetSelectedRow () const throw();
        unsigned GetNbRow () const throw();

        static const int None = -1;


      protected :
        CGtkGUI* GetUI () throw();
        const CGtkGUI* GetUI () const throw();
        void RowTriggered () throw();
        virtual void RowSelectedCallBack () throw();
        virtual void RowUnselectedCallBack () throw();


      private :
        CSelectableRowList& operator = (const CSelectableRowList&);
        CSelectableRowList (const CSelectableRowList&);

        void SetData (unsigned Row, unsigned Column, ::GValue*) throw();

        ::GtkListStore* const m_pListStore;
        ::GtkTreeView* const m_pListView;
        ::GtkWidget* const m_pScrollWindow;
        ::GtkCellRendererToggle* m_pButtonRenderer;
        std::vector< ::GtkTreeIter> m_IterVec;
        int m_SelectedRow;
        CGtkGUI* const m_pUI;
        GUICallBack m_pGUICallBack;

        static void DoubleClickCallBack (::GtkTreeView*, ::GtkTreePath*,
                                         ::GtkTreeViewColumn*,
                                         CSelectableRowList*) throw();
        static void ToggledCallBack (::GtkCellRendererToggle*, const char*,
                                     CSelectableRowList*) throw();
        static bool _RowSelectedCallBack (::GtkTreeSelection*, ::GtkTreeModel*,
                                          ::GtkTreePath*, bool,
                                          CSelectableRowList*) throw();

    }; // CSelectableRowList

} // namespace nsGUI

#include "private/CSelectableRowList.hxx"

#endif // __CSELECTABLEROWLIST_H__
