/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_row_tell(char * fname)
{
  // MYSQL_ROW_OFFSET is an equivalent to MYSQL_ROWS *
  int * sql_res_pointer_in = NULL;
  MYSQL_RES * mysql_res_ptr_in = NULL;
  MYSQL_ROW_OFFSET mysql_row_offset_ptr_out;
  void * ptr_in = NULL;
  SciErr _SciErr;

  CheckRhs(1,1);
  CheckLhs(1,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_res_pointer_in);
  getPointer(pvApiCtx, sql_res_pointer_in, &ptr_in);
  mysql_res_ptr_in = (MYSQL_RES *)ptr_in;

  if (mysql_res_ptr_in==NULL)
    {
      Scierror(999,"%s: problem with the mysql_res pointer\n", fname);
      return 0;
    }

  mysql_row_offset_ptr_out = mysql_row_tell(mysql_res_ptr_in);

  if (mysql_row_offset_ptr_out)
    {
      _SciErr = createPointer(pvApiCtx, Rhs+1, (void *)mysql_row_offset_ptr_out);
    }
  else
    {
      createEmptyMatrix(pvApiCtx, Rhs+1);
    }

  LhsVar(1) = Rhs+1;

  return 0;
}
